/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.TObject;
import com.mckoi.database.TransactionSystem;
import com.mckoi.util.Cache;

final class DataCellCache {
    private final TransactionSystem system;
    private int MAX_CELL_SIZE;
    private final DCCache cache;
    private long current_cache_size;
    private static final int[] PRIME_LIST = new int[]{3001, 4799, 13999, 15377, 21803, 24247, 35083, 40531, 43669, 44263, 47387, 50377, 57059, 57773, 59399, 59999, 75913, 96821, 140551, 149011, 175633, 176389, 183299, 205507, 209771, 223099, 240259, 258551, 263909, 270761, 274679, 286129, 290531, 296269, 298021, 300961, 306407, 327493, 338851, 351037, 365489, 366811, 376769, 385069, 410623, 430709, 433729, 434509, 441913, 458531, 464351, 470531, 475207, 479629, 501703, 510709, 516017, 522211, 528527, 536311, 539723, 557567, 593587, 596209, 597451, 608897, 611069, 642547, 670511, 677827, 679051, 688477, 696743, 717683, 745931, 757109, 760813, 763957, 766261, 781559, 785597, 788353, 804493, 813559, 836917, 854257, 859973, 883217, 884789, 891493, 902281, 910199, 915199, 930847, 939749, 940483, 958609, 963847, 974887, 983849, 984299, 996211, 999217, 1007519, 1013329, 1014287, 1032959, 1035829, 1043593, 1046459, 1076171, 1078109, 1081027, 1090303, 1095613, 1098847, 1114037, 1124429, 1125017, 1130191, 1159393, 1170311, 1180631, 1198609, 1200809, 1212943, 1213087, 1226581, 1232851, 1287109, 1289867, 1297123, 1304987, 1318661, 1331107, 1343161, 1345471, 1377793, 1385117, 1394681, 1410803, 1411987, 1445261, 1460497, 1463981, 1464391, 1481173, 1488943, 1491547, 1492807, 1528993, 1539961, 1545001, 1548247, 1549843, 1551001, 1553023, 1571417, 1579099, 1600259, 1606153, 1606541, 1639751, 1649587, 1657661, 1662653, 1667051, 0x199009, 1678837, 1715537, 1718489, 1726343, 1746281, 1749107, 1775489, 1781881, 1800157, 1806859, 1809149, 1826753, 1834607, 1846561, 1849241, 1851991, 1855033, 1879931, 1891133, 1893737, 1899137, 1909513, 1916599, 1917749, 1918549, 1919347, 1925557, 1946489, 1961551, 1965389, 2011073, 2033077, 0x1F1FD1, 2054047, 2060171, 2082503, 2084107, 2095099, 2096011, 2112193, 2125601, 2144977, 2150831, 2157401, 0x211D1D, 2221829, 0x2212BB, 2269027, 2270771, 2292449, 2299397, 2303867, 2309891, 2312407, 2344301, 2348573, 2377007, 2385113, 2386661, 2390051, 2395763, 2422999, 2448367, 2500529, 2508203, 2509841, 2513677, 2516197, 2518151, 2518177, 2542091, 2547469, 2549951, 2556991, 2563601, 2575543, 2597629, 2599577, 2612249, 2620003, 2626363, 2626781, 2636773, 2661557, 2674297, 2691571, 2718269, 2725691, 2729381, 2772199, 2774953, 2791363, 2792939, 2804293, 2843021, 2844911, 2851313, 2863519, 2880797, 2891821, 2897731, 2904887, 2910251, 2928943, 2958341, 2975389};

    DataCellCache(TransactionSystem system, int max_cache_size, int max_cell_size, int hash_size) {
        this.system = system;
        this.MAX_CELL_SIZE = max_cell_size;
        this.cache = new DCCache(hash_size, max_cache_size);
    }

    DataCellCache(TransactionSystem system, int max_cache_size, int max_cell_size) {
        this(system, max_cache_size, max_cell_size, 88547);
    }

    public synchronized void alterCacheDynamics(int max_cache_size, int max_cell_size) {
        this.MAX_CELL_SIZE = max_cell_size;
        this.cache.setCacheSize(max_cache_size);
    }

    private static final int amountMemory(TObject cell) {
        return 16 + cell.approximateMemoryUse();
    }

    public synchronized void put(int table_key, int row, int column, TObject cell) {
        int memory_use = DataCellCache.amountMemory(cell);
        if (memory_use <= this.MAX_CELL_SIZE) {
            DCCacheKey key = new DCCacheKey(table_key, (short)column, row);
            TObject removed_cell = (TObject)this.cache.remove(key);
            if (removed_cell != null) {
                this.current_cache_size -= (long)DataCellCache.amountMemory(removed_cell);
            }
            this.cache.put(key, cell);
            this.current_cache_size += (long)memory_use;
        } else {
            this.remove(table_key, row, column);
        }
    }

    public synchronized TObject get(int table_key, int row, int column) {
        return (TObject)this.cache.get(new DCCacheKey(table_key, (short)column, row));
    }

    public synchronized TObject remove(int table_key, int row, int column) {
        TObject cell = (TObject)this.cache.remove(new DCCacheKey(table_key, (short)column, row));
        if (cell != null) {
            this.current_cache_size -= (long)DataCellCache.amountMemory(cell);
        }
        return cell;
    }

    public synchronized void wipe() {
        if (this.cache.nodeCount() == 0 && this.current_cache_size != 0L) {
            this.system.Debug().write(40, this, "Assertion failed - if nodeCount = 0 then current_cache_size must also be 0.");
        }
        if (this.cache.nodeCount() != 0) {
            this.cache.removeAll();
            this.system.stats().increment("DataCellCache.total_cache_wipe");
        }
        this.current_cache_size = 0L;
    }

    public synchronized long getCurrentCacheSize() {
        return this.current_cache_size;
    }

    private void reduceCacheSize(long val) {
        this.current_cache_size -= val;
    }

    static int closestPrime(int value) {
        for (int i = 0; i < PRIME_LIST.length; ++i) {
            if (PRIME_LIST[i] < value) continue;
            return PRIME_LIST[i];
        }
        return PRIME_LIST[PRIME_LIST.length - 1];
    }

    private final class DCCache
    extends Cache {
        private int MAX_CACHE_SIZE;

        public DCCache(int cache_hash_size, int max_cache_size) {
            super(cache_hash_size, -1, 20);
            this.MAX_CACHE_SIZE = max_cache_size;
        }

        public void setCacheSize(int cache_size) {
            this.MAX_CACHE_SIZE = cache_size;
            this.checkClean();
        }

        protected void checkClean() {
            if (DataCellCache.this.getCurrentCacheSize() >= (long)this.MAX_CACHE_SIZE) {
                DataCellCache.this.system.stats().set((int)DataCellCache.this.getCurrentCacheSize(), "DataCellCache.current_cache_size");
                this.clean();
                DataCellCache.this.system.stats().increment("DataCellCache.cache_clean");
            }
        }

        protected boolean shouldWipeMoreNodes() {
            return DataCellCache.this.getCurrentCacheSize() >= (long)((int)((long)this.MAX_CACHE_SIZE * 100L / 115L));
        }

        protected void notifyWipingNode(Object ob) {
            super.notifyWipingNode(ob);
            TObject cell = (TObject)ob;
            DataCellCache.this.reduceCacheSize(DataCellCache.amountMemory(cell));
        }

        protected void notifyGetWalks(long total_walks, long total_get_ops) {
            int avg = (int)(total_walks * 1000000L / total_get_ops);
            DataCellCache.this.system.stats().set(avg, "DataCellCache.avg_hash_get_mul_1000000");
            DataCellCache.this.system.stats().set((int)DataCellCache.this.getCurrentCacheSize(), "DataCellCache.current_cache_size");
            DataCellCache.this.system.stats().set(this.nodeCount(), "DataCellCache.current_node_count");
        }
    }

    private static final class DCCacheKey {
        final int row;
        final short column;
        final int table_id;

        DCCacheKey(int table_id, short column, int row) {
            this.table_id = table_id;
            this.column = column;
            this.row = row;
        }

        public boolean equals(Object ob) {
            DCCacheKey dest_key = (DCCacheKey)ob;
            return this.row == dest_key.row && this.column == dest_key.column && this.table_id == dest_key.table_id;
        }

        public int hashCode() {
            return (this.column + this.table_id + this.row * 189977) * 50021 << 4;
        }
    }
}

